#!/usr/bin/perl

use Cwd;

$curDir = getcwd();

if(-f "$curDir/egan-install.cus")
{
	print "running egan";
	`perl $curDir/egan-install.cus`;
}

# Check that we are not already installed

if(-f "/etc/X11/xorg.conf")
{
  open XC, "</etc/X11/xorg.conf";
}
elsif(-f "/etc/X11/XF86Config-4")
{
  open XC, "</etc/X11/XF86Config-4";
}
else
{
  open XC, "</etc/X11/XF86Config";
}
$flag = 0;
while($test = <XC>) {
  $test=~s/^\s+//;
  $test=~s/\s+$//;
  if($test eq "Option \"Device\" \"/opt/tbupddlx/comReadPipe\"") {
    $flag = 1;
  }
}
close(XC);

# Adds the relative sections needed for xf86_tbupddlx.o to work w/XF86 4.x

if($flag == 0) {
  if(-f "/etc/X11/xorg.conf")
  {
    open XIN, "</etc/X11/xorg.conf";
  }
  elsif(-f "/etc/X11/XF86Config-4")
  {
    open XIN, "</etc/X11/XF86Config-4";
  }
  else
  {
    open XIN, "</etc/X11/XF86Config";
  }
  open XOUT, ">/etc/X11/XF86Config-4.new";

  print XOUT "Section \"InputDevice\" #UPDD\n";
  print XOUT "	Identifier \"Updd0\"\n";
  print XOUT "	Driver \"xf86_tbupddlx\"\n";
  print XOUT "  Option \"SwapXY\" \"0\"\n";
  print XOUT "	Option \"Device\" \"/opt/tbupddlx/comReadPipe\"\n";
  print XOUT "EndSection #UPDD\n\n";

  while($buf = <XIN>) {
    print XOUT $buf;
    chop($buf);
    if($buf eq "Section \"ServerLayout\"") {
      print XOUT "	InputDevice \"Updd0\" \"SendCoreEvents\"\n";
    }
  }
  
  close XIN;
  close XOUT:
  
  if(-f "/etc/X11/xorg.conf")
  {
    `mv /etc/X11/XF86Config-4.new /etc/X11/xorg.conf`;
  }
  elsif(-f "/etc/X11/XF86Config-4")
  {
    `mv /etc/X11/XF86Config-4.new /etc/X11/XF86Config-4`;
  }
  else
  {
    `mv /etc/X11/XF86Config-4.new /etc/X11/XF86Config`;
  }

  
} else {
  print "XF86Config-4 has already been patched.\n";
}